var samplePageObj = {

  externalScript: ['../assets/ibsheet/plugins/ibsheet-excel.js'],

  // 샘플 타이틀
  title: '파일 가져오기(업로드) 예제',
  subtitle: '외부파일의 내용을 시트에 로드합니다.',
  // 샘플 설명
  desc: 'loadExcel(),loadText()함수를 통해 엑셀파일이나, csv,txt파일을 파싱하여 시트에 로드할 수 있습니다.',

  // 객체 초기화 구문
  init: {
    Cfg: {
      SearchMode: 0,
      HeaderMerge: 6,
      FitWidth: 1,
      Export: { Url: (location.href.indexOf('localhost') > -1 ? '../jsp/' : 'https://api.ibleaders.com/ibsheet/v8/') }, // 다운 jsp URL
    },
    Cols: [
      {
        Header: [
          '신청인',
          '신청인'
        ],
        Type: 'Text',
        MinWidth: 80,
        Name: 'sName',
        ColMerge: 1
      },
      {
        Header: [
          '선택',
          '선택'
        ],
        Type: 'Bool',
        MinWidth: 80,
        Name: 'check',
        ColMerge: 1
      },
      {
        Header: [
          '신청사유',
          '신청사유'
        ],
        Type: 'Enum',
        MinWidth: 80,
        Name: 'Reason',
        ColMerge: 0,
        Align: 'Center',
        Enum: '|야근|주말특근|휴일특근',
        EnumKeys: '|01|02|03'
      },
      {
        Header: [
          '신청금액',
          '신청금액'
        ],
        Type: 'Int',
        MinWidth: 85,
        Name: 'Qty',
        ColMerge: 1,
        Required: 1
      },
      {
        Header: [
          '근태기간',
          '시작일'
        ],
        Name: 'Date1',
        Extend: IB_Preset.YMD
      },
      {
        Header: [
          '근태기간',
          '종료일'
        ],
        Name: 'Date2',
        Extend: IB_Preset.YMD
      },
      {
        Header: [
          '시간',
          '시작'
        ],
        Name: 'Time1',
        Extend: IB_Preset.HM
      },
      {
        Header: [
          '시간',
          '종료'
        ],
        Name: 'Time2',
        Extend: IB_Preset.HM
      }
    ],
  },

  // 버튼/기능 영역 html (sampleBtn으로 호출하면 action함수로 연결)
  func: '<div><button type=\'button\' class=\'mgr10\' onclick=\'sampleBtn(this)\'>엑셀파일 업로드</button>'
  + '<button type=\'button\' class=\'mgr10\' onclick=\'sampleBtn(this)\'>txt 파일 업로드</button>'
  + '<button type=\'button\' class=\'mgr10\' onclick=\'sampleBtn(this)\'>시트 데이터 클리어</button></div>'
  + '<div><button type=\'button\' class=\'mgr10\' onclick=\'sampleBtn(this)\'>엑셀 업로드 다이얼로그</button>'
  + '<button type=\'button\' class=\'mgr10\' onclick=\'sampleBtn(this)\'>txt/csv 업로드 다이얼로그</button>'
  + '</div>',

  // 객체 생성 Html
  objEl: '<div id=\'sheetDiv\' style=\'width:100%;height:100%\'></div>',

  // 시트 하단 영역 html
  footer: '',

  // 객체 생성 구문
  create: function () {
    var options = this.init;

    options.Events = this.event;
    IBSheet.create({
      id: 'sheet', // 생성할 시트의 id
      el: 'sheetDiv', // 시트를 생성할 Dom 객체 및 id
      options: options, // 생성될 시트의 속성
      data: this.data // 생성될 시트의 정적데이터
    });
  },
  // 버튼 클릭시 기능 로직
  action: function (obj) {
    switch (obj.textContent) {
      case '엑셀파일 업로드':
        sheet.loadExcel({ mode: 'HeaderMatch' });
        break;
      case 'txt 파일 업로드':
        sheet.loadText({ mode: 'HeaderMatch' });
        break;
      case '시트 데이터 클리어':
        sheet.removeAll();
        break;
      case '엑셀 업로드 다이얼로그':
        sheet.showUploadDialog('excel');
        break;
      case 'txt/csv 업로드 다이얼로그':
        sheet.showUploadDialog('txt');
        break;
      // no default
    }
  },

  // event구문
  event: {
    onImportFinish: function (evtParam) {
      console.log('데이터 import 완료', 'onImportFinish', evtParam.type, evtParam.data);
    },
    onSelectFile: function (evtParam) {
      console.log(evtParam.eventName + ' 발생');
    }
  },

  // data
  data: []
};

var sampleBtn = function () {
  var args = Array.prototype.slice.call(arguments, 0);

  samplePageObj.action.apply(null, args);
};
